/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.capistrano.ui.wizard;

import com.aptana.core.util.ExecutableUtil;
import com.aptana.deploy.capistrano.ui.wizard.CapifyProjectPage;
import com.aptana.deploy.capistrano.ui.wizard.CapistranoDeployWizard;
import com.aptana.deploy.capistrano.ui.wizard.Messages;
import com.aptana.terminal.widget.TerminalComposite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class InstallCapistranoGemPage
extends WizardPage {
    private static final String NAME = "InstallCapistrano";
    private TerminalComposite terminalComposite;
    private IWizardPage fNextPage;
    protected Job checkGemInstalledJob;

    protected InstallCapistranoGemPage() {
        super(NAME, Messages.InstallCapistranoGemPage_Title, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(composite, 64);
        label.setText(Messages.InstallCapistranoGemPage_Description);
        label.setLayoutData((Object)new GridData(500, -1));
        Button generateButton = new Button(composite, 8);
        generateButton.setText(Messages.InstallCapistranoGemPage_InstallGemLabel);
        generateButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!InstallCapistranoGemPage.this.terminalComposite.isEmpty()) {
                    InstallCapistranoGemPage.this.terminalComposite.clear();
                }
                if (!ExecutableUtil.isGemInstallable()) {
                    InstallCapistranoGemPage.this.terminalComposite.sendInput("sudo ");
                }
                InstallCapistranoGemPage.this.terminalComposite.sendInput("gem install capistrano\n");
                if (InstallCapistranoGemPage.this.checkGemInstalledJob == null) {
                    InstallCapistranoGemPage.this.checkGemInstalledJob = new Job("Checking if capistrano gem is installed"){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (monitor != null && monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            if (InstallCapistranoGemPage.isCapistranoGemInstalled()) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        InstallCapistranoGemPage.this.getContainer().updateButtons();
                                    }
                                });
                            } else {
                                this.schedule(1000L);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    InstallCapistranoGemPage.this.checkGemInstalledJob.setSystem(true);
                }
                InstallCapistranoGemPage.this.checkGemInstalledJob.cancel();
                InstallCapistranoGemPage.this.checkGemInstalledJob.schedule(1000L);
            }
        });
        this.terminalComposite = new TerminalComposite(composite, 0);
        this.terminalComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.terminalComposite.setWorkingDirectory(this.getProject().getLocation());
        this.terminalComposite.connect();
        Dialog.applyDialogFont((Control)composite);
    }

    public void dispose() {
        try {
            if (this.checkGemInstalledJob != null) {
                this.checkGemInstalledJob.cancel();
                this.checkGemInstalledJob = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    public IWizardPage getNextPage() {
        if (this.fNextPage == null) {
            this.fNextPage = new CapifyProjectPage();
            this.fNextPage.setWizard(this.getWizard());
        }
        return this.fNextPage;
    }

    public boolean isPageComplete() {
        return InstallCapistranoGemPage.isCapistranoGemInstalled();
    }

    static boolean isCapistranoGemInstalled() {
        IPath path = ExecutableUtil.find((String)"capify", (boolean)false, null);
        return path != null && path.toFile().exists();
    }

    protected IProject getProject() {
        return ((CapistranoDeployWizard)this.getWizard()).getProject();
    }
}

